﻿namespace Microsoft.Samples.PlanMyNight.Infrastructure.Mvc
{
    using System.Collections.Generic;
    using System.Web;
    using System.Web.Mvc;
    using System.Web.Routing;
    using Microsoft.Samples.PlanMyNight.Infrastructure;

    public static class AddinExtensions
    {
        public static IEnumerable<RouteValueDictionary> GetActionsFor(string extensionTarget, object extraRouteValues)
        {
            foreach (var export in ServiceLocator.Current.GetExports<RouteValueDictionary, IExtensionSiteMetadata>())
            {
                if (export.Metadata.TargetExtensionSite == extensionTarget)
                {
                    var route = export.Value;
                    foreach (var routeValue in new RouteValueDictionary(extraRouteValues))
                    {
                        if (!route.ContainsKey(routeValue.Key)) route.Add(routeValue.Key, routeValue.Value);
                    }

                    yield return route;
                }
            }
        }

        public static IEnumerable<ExtensionLink> GetLinksFor(string extensionTarget, object extraRouteValues)
        {
            foreach (var export in ServiceLocator.Current.GetExports<ExtensionLink, IExtensionSiteMetadata>())
            {
                if (export.Metadata.TargetExtensionSite == extensionTarget)
                {
                    var route = export.Value;
                    foreach (var routeValue in new RouteValueDictionary(extraRouteValues))
                    {
                        if (!route.RouteLink.ContainsKey(routeValue.Key)) route.RouteLink.Add(routeValue.Key, routeValue.Value);
                    }

                    yield return route;
                }
            }
        }

        public static void RenderAddinRoute(this HtmlHelper helper, RouteValueDictionary routeValues)
        {
            var routeData = new RouteData();
            foreach (var kvp in routeValues)
            {
                routeData.Values.Add(kvp.Key, kvp.Value);
            }

            var httpContext = helper.ViewContext.HttpContext;
            var requestContext = new RequestContext(httpContext, routeData);

            if (routeValues.ContainsKey("area"))
            {
                requestContext.RouteData.DataTokens["area"] = routeValues["area"];
            }

            var handler = new RenderActionMvcHandler(requestContext);
            handler.ProcessRequestInternal(httpContext);
        }

        // Extracted from Mvc.Future
        private class RenderActionMvcHandler : MvcHandler
        {
            public RenderActionMvcHandler(RequestContext context)
                : base(context)
            {
            }

            public void ProcessRequestInternal(HttpContextBase httpContext)
            {
                this.ProcessRequest(httpContext);
            }

            protected override void AddVersionHeader(HttpContextBase httpContext)
            {
                // Don't try to set the version header when rendering actions
            }
        }
    }
}
